<?php
// الاتصال بقاعدة البيانات
include('admin_user_pass.php');

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// الحصول على التاريخ ونوع الزر من الرابط
$date = $_GET['date'] ?? null;
$button_type = $_GET['button_type'] ?? null;

if (!$date || !$button_type) {
    die("لم يتم اختيار تاريخ أو نوع زر , الرجاء اختيار بيانات صحيحة.");
}

// استعلام لجلب النقرات اليومية لهذا التاريخ ونوع الزر
$sql_daily = "
    SELECT 
        button_type,
        click_time
    FROM clicks
    WHERE DATE(click_time) = '$date' AND button_type = '$button_type'
    ORDER BY click_time ASC
";
$result_daily = $conn->query($sql_daily);

// استعلام لحساب مجموع النقرات لهذا التاريخ ونوع الزر
$sql_total = "SELECT COUNT(*) AS total_clicks FROM clicks WHERE DATE(click_time) = '$date' AND button_type = '$button_type'";
$result_total = $conn->query($sql_total);
$total_clicks = $result_total->fetch_assoc()['total_clicks'] ?? 0;
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>النقرات اليومية لتاريخ <?php echo htmlspecialchars($date); ?> ونوع الزر <?php echo htmlspecialchars($button_type); ?></title>
    <link rel="stylesheet" href="css/styles.css"> <!-- رابط ملف CSS -->
    <style>
        /* تنسيق الجدول */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        table th, table td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: center;
        }

        /* تنسيق الأزرار */
        .btn-back {
            background-color: #4CAF50;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            display: inline-block;
            margin-top: 20px;
        }

        .btn-back:hover {
            background-color: #45a049;
        }

        /* تنسيق النصوص */
        .heading {
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>النقرات اليومية لتاريخ <?php echo htmlspecialchars($date); ?> ونوع الزر <?php echo htmlspecialchars($button_type); ?></h1>

        <!-- عرض البيانات في جدول -->
        <table>
            <thead>
                <tr>
                    <th>نوع الزر</th>
                    <th>تاريخ ووقت الضغط</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result_daily->num_rows > 0) {
                    while ($row = $result_daily->fetch_assoc()) {
                        echo "<tr>
                                <td>" . htmlspecialchars($row['button_type']) . "</td>
                                <td>" . htmlspecialchars($row['click_time']) . "</td>
                              </tr>";
                    }
                } else {
                    echo "<tr><td colspan='2'>لا توجد نقرات لهذا التاريخ ونوع الزر.</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <!-- عرض إجمالي النقرات -->
        <h2 class="heading">إجمالي النقرات لهذا اليوم: <?php echo $total_clicks; ?></h2>

        <!-- زر العودة -->
        <a href="javascript:history.back()" class="btn-back">رجوع إلى الصفحة السابقة</a>
    </div>
</body>
</html>

<?php
$conn->close();
?>
