<?php
// الاتصال بقاعدة البيانات
include('admin_user_pass.php');

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// التحقق من وجود تاريخ محدد في الرابط
$date = $_GET['date'] ?? null;

if (!$date) {
    die("لم يتم اختيار تاريخ محدد، الرجاء اختيار تاريخ.");
}

// جلب عدد الزيارات اليومية للتاريخ المحدد من جدول daily_visits
$sql_daily = "
    SELECT visit_date, visit_count
    FROM daily_visits
    WHERE visit_date = '$date';
";

$result_daily = $conn->query($sql_daily);

// حساب المجموع الكلي للزيارات لجميع التواريخ
$sql_total = "
    SELECT SUM(visit_count) AS total_visits
    FROM daily_visits;
";

$result_total = $conn->query($sql_total);
$total_visits = $result_total->fetch_assoc()['total_visits'] ?? 0;
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>زيارات الموقع بتاريخ <?php echo $date; ?></title>
    <link rel="stylesheet" href="css/styles.css"> <!-- رابط ملف CSS -->
</head>
<body>
    <h1>زيارات الموقع ليوم <?php echo $date; ?></h1>
    
    <table border="1" style="width: 50%; margin: auto; text-align: center;">
        <tr>
            <th>التاريخ</th>
            <th>عدد الزيارات</th>
        </tr>
        <?php
        if ($result_daily->num_rows > 0) {
            while ($row = $result_daily->fetch_assoc()) {
                echo "<tr>
                        <td>{$row['visit_date']}</td>
                        <td>{$row['visit_count']}</td>
                      </tr>";
            }
        } else {
            echo "<tr><td colspan='2'>لا يوجد زيارات مسجلة لهذا اليوم.</td></tr>";
        }
        ?>
    </table>

    <h2 style="text-align: center; margin-top: 20px;">إجمالي الزيارات لليوم: <?php echo $total_visits; ?></h2>

    <div style="text-align: center; margin-top: 20px;">
        <button>
            <a href="select_date_visits.php" style="text-decoration: none; color: black;">العودة لاختيار التاريخ</a>
        </button>
    </div>
</body>
</html>

<?php
$conn->close();
?>
